/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryAdapter<T extends IForgeRegistryEntry<T>> {
    private final IForgeRegistry<T> registry;
    private final String modId;

    public RegistryAdapter(IForgeRegistry<T> registry) {
        this(registry, ModLoadingContext.get().getActiveContainer().getModId());
    }

    public ResourceLocation getResource(String name) {
        return new ResourceLocation(this.modId, name);
    }

    public String resourceName(String name) {
        return this.modId + ":" + name;
    }

    public <I extends T> I register(I entry, String name) {
        return this.register(entry, this.getResource(name));
    }

    public <I extends T> I register(I entry, IForgeRegistryEntry<?> name) {
        return this.register(entry, Objects.requireNonNull(name.getRegistryName()));
    }

    public <I extends T> I register(I entry, ResourceLocation location) {
        entry.setRegistryName(location);
        this.registry.register(entry);
        return entry;
    }

    public RegistryAdapter(IForgeRegistry<T> registry, String modId) {
        this.registry = registry;
        this.modId = modId;
    }
}

